/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedFileHashUtil {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedFileHashUtil.class);
    private static final long DEFAULT_SEED = 0L;
    private static final int MMAP_CHUNK_SIZE = 0x4000000;
    private static final long LARGE_FILE_THRESHOLD = 524288000L;
    private static final int CPU_CORES = Runtime.getRuntime().availableProcessors();
    private static final int THREAD_COUNT = Math.max(4, CPU_CORES * 2);

    public static long calculate_file_hash_optimized(String file_path) throws IOException {
        return OptimizedFileHashUtil.calculate_file_hash_optimized(file_path, 0L);
    }

    public static long calculate_file_hash_optimized(String file_path, long seed) throws IOException {
        Path path = Paths.get(file_path, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)file_path);
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + file_path);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            logger.error("\u6307\u5b9a\u8def\u5f84\u4e0d\u662f\u6587\u4ef6: {}", (Object)file_path);
            throw new IllegalArgumentException("\u6307\u5b9a\u8def\u5f84\u4e0d\u662f\u6587\u4ef6: " + file_path);
        }
        long fileSize = Files.size(path);
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u6587\u4ef6hash: {}, \u6587\u4ef6\u5927\u5c0f: {} MB", (Object)file_path, (Object)(fileSize / 0x100000L));
        long startTime = System.currentTimeMillis();
        long hash = fileSize > 524288000L ? OptimizedFileHashUtil.calculate_large_file_hash_concurrent(file_path, seed) : OptimizedFileHashUtil.calculate_small_file_hash_optimized(file_path, seed);
        long endTime = System.currentTimeMillis();
        double timeSeconds = (double)(endTime - startTime) / 1000.0;
        double speedMBps = (double)fileSize / 1048576.0 / timeSeconds;
        logger.info("\u6587\u4ef6hash\u8ba1\u7b97\u5b8c\u6210: {}, \u8017\u65f6: {:.2f}\u79d2, \u901f\u5ea6: {:.2f} MB/s, hash\u503c: {}", file_path, timeSeconds, speedMBps, hash);
        return hash;
    }

    private static long calculate_large_file_hash_concurrent(String file_path, long seed) throws IOException {
        XXHashFactory factory = XXHashFactory.fastestInstance();
        try (RandomAccessFile raf = new RandomAccessFile(file_path, "r");){
            long l;
            block15: {
                long fileSize;
                FileChannel channel;
                block13: {
                    long l2;
                    block14: {
                        channel = raf.getChannel();
                        try {
                            fileSize = channel.size();
                            if (fileSize <= 0x8000000L || THREAD_COUNT <= 1) break block13;
                            l2 = OptimizedFileHashUtil.calculate_hash_with_threading(channel, fileSize, seed, factory, file_path);
                            if (channel == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return l2;
                }
                l = OptimizedFileHashUtil.calculate_hash_with_mmap(channel, fileSize, seed, factory);
                if (channel == null) break block15;
                channel.close();
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long calculate_hash_with_threading(FileChannel channel, long fileSize, long seed, XXHashFactory factory, String file_path) throws IOException {
        long maxHeapMemory = Runtime.getRuntime().maxMemory();
        long availableMemory = maxHeapMemory - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        long maxChunkSize = Math.min(0x4000000L, availableMemory / 10L);
        maxChunkSize = Math.max(0x100000L, maxChunkSize);
        int actualThreadCount = Math.min(THREAD_COUNT, (int)(availableMemory / 0x2000000L));
        actualThreadCount = Math.max(1, actualThreadCount);
        long chunkSize = Math.min(maxChunkSize, fileSize / (long)actualThreadCount);
        int numChunks = (int)Math.ceil((double)fileSize / (double)chunkSize);
        logger.info("\u4f7f\u7528\u591a\u7ebf\u7a0b\u8ba1\u7b97: {} \u4e2a\u7ebf\u7a0b, {} \u4e2a\u5757, \u6bcf\u5757\u5927\u5c0f: {} MB, \u53ef\u7528\u5185\u5b58: {} MB", actualThreadCount, numChunks, chunkSize / 0x100000L, availableMemory / 0x100000L);
        if ((long)numChunks * (chunkSize / 0x100000L) > availableMemory / 0x200000L) {
            logger.warn("\u5185\u5b58\u4e0d\u8db3\u4ee5\u652f\u6301\u5e76\u53d1\u8ba1\u7b97\uff0c\u6539\u7528\u5355\u7ebf\u7a0b\u5185\u5b58\u6620\u5c04");
            return OptimizedFileHashUtil.calculate_hash_with_mmap(channel, fileSize, seed, factory);
        }
        ExecutorService executor = Executors.newFixedThreadPool(actualThreadCount);
        ExecutorCompletionService<ChunkHashResult> completionService = new ExecutorCompletionService<ChunkHashResult>(executor);
        try {
            for (int i = 0; i < numChunks; ++i) {
                long chunkStart = (long)i * chunkSize;
                long chunkEnd = Math.min(chunkStart + chunkSize, fileSize);
                long actualChunkSize = chunkEnd - chunkStart;
                completionService.submit(new ChunkHashCalculator(channel, chunkStart, actualChunkSize, i, factory, file_path));
            }
            ChunkHashResult[] results = new ChunkHashResult[numChunks];
            for (int i = 0; i < numChunks; ++i) {
                try {
                    ChunkHashResult result;
                    results[result.chunkIndex] = result = (ChunkHashResult)completionService.take().get();
                    if ((i + 1) % 10 != 0 && i != numChunks - 1) continue;
                    logger.info("\u5757 {}/{} \u8ba1\u7b97\u5b8c\u6210", (Object)(i + 1), (Object)numChunks);
                    System.gc();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException("\u5e76\u53d1\u54c8\u5e0c\u8ba1\u7b97\u5931\u8d25", e);
                }
            }
            XXHash64 hasher = factory.hash64();
            long finalHash = seed;
            for (ChunkHashResult result : results) {
                finalHash = hasher.hash(OptimizedFileHashUtil.longToBytes(result.hash), 0, 8, finalHash);
            }
            long l = finalHash;
            return l;
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long calculate_hash_with_mmap(FileChannel channel, long fileSize, long seed, XXHashFactory factory) throws IOException {
        XXHash64 hasher = factory.hash64();
        long hash = seed;
        long position = 0L;
        while (position < fileSize) {
            long remainingBytes = fileSize - position;
            int mapSize = (int)Math.min(0x4000000L, remainingBytes);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, position, mapSize);
            try {
                if (buffer.hasArray()) {
                    hash = hasher.hash(buffer.array(), buffer.arrayOffset(), mapSize, hash);
                } else {
                    byte[] tempBuffer = new byte[mapSize];
                    buffer.get(tempBuffer);
                    hash = hasher.hash(tempBuffer, 0, mapSize, hash);
                }
                int progress = (int)((position += (long)mapSize) * 100L / fileSize);
                if (position % 0x4000000L != 0L && position != fileSize) continue;
                logger.info("\u5185\u5b58\u6620\u5c04\u8ba1\u7b97\u8fdb\u5ea6: {}%", (Object)progress);
            }
            finally {
                if (!buffer.isDirect()) continue;
                try {
                    Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
                    if (cleaner == null) continue;
                    Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    cleanMethod.invoke(cleaner, new Object[0]);
                }
                catch (Exception exception) {}
            }
        }
        return hash;
    }

    private static long calculate_small_file_hash_optimized(String file_path, long seed) throws IOException {
        XXHashFactory factory = XXHashFactory.fastestInstance();
        XXHash64 hasher = factory.hash64();
        File file = new File(file_path);
        long fileSize = file.length();
        int bufferSize = fileSize <= 0x100000L ? 131072 : (fileSize <= 0x6400000L ? 0x100000 : 0x400000);
        try (FileInputStream fis = new FileInputStream(file_path);){
            long l;
            try (BufferedInputStream bis = new BufferedInputStream(fis, bufferSize);){
                int bytesRead;
                byte[] buffer = new byte[bufferSize];
                long hash = seed;
                long totalBytes = 0L;
                while ((bytesRead = bis.read(buffer)) != -1) {
                    hash = hasher.hash(buffer, 0, bytesRead, hash);
                    totalBytes += (long)bytesRead;
                }
                logger.debug("\u5c0f\u6587\u4ef6\u5904\u7406\u5b8c\u6210\uff0c\u603b\u5b57\u8282\u6570: {}", (Object)totalBytes);
                l = hash;
            }
            return l;
        }
    }

    private static byte[] longToBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    public static void printOptimizationInfo() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int processors = Runtime.getRuntime().availableProcessors();
        System.out.println("=== \u6587\u4ef6\u54c8\u5e0c\u8ba1\u7b97\u4f18\u5316\u4fe1\u606f ===");
        System.out.println("\u53ef\u7528\u5904\u7406\u5668\u6570\u91cf: " + processors);
        System.out.println("\u6700\u5927\u5806\u5185\u5b58: " + maxMemory / 1024L / 1024L + " MB");
        System.out.println("\u5185\u5b58\u6620\u5c04\u5757\u5927\u5c0f: 64 MB");
        System.out.println("\u5927\u6587\u4ef6\u9608\u503c: 500 MB");
        System.out.println("\u5e76\u53d1\u7ebf\u7a0b\u6570: " + THREAD_COUNT);
        System.out.println("=============================");
    }

    private static class ChunkHashCalculator
    implements Callable<ChunkHashResult> {
        private final FileChannel channel;
        private final long start;
        private final long size;
        private final int chunkIndex;
        private final XXHashFactory factory;
        private final String filePath;

        public ChunkHashCalculator(FileChannel channel, long start, long size, int chunkIndex, XXHashFactory factory, String filePath) {
            this.channel = channel;
            this.start = start;
            this.size = size;
            this.chunkIndex = chunkIndex;
            this.factory = factory;
            this.filePath = filePath;
        }

        @Override
        public ChunkHashResult call() throws Exception {
            XXHash64 hasher = this.factory.hash64();
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory();
                long totalMemory = runtime.totalMemory();
                long usedMemory = totalMemory - freeMemory;
                long maxMemory = runtime.maxMemory();
                if ((double)usedMemory > (double)maxMemory * 0.8) {
                    System.gc();
                    Thread.sleep(100L);
                }
                if (this.size > 0x2000000L) {
                    return this.calculateHashStreaming();
                }
                return this.calculateHashMapped();
            }
            catch (OutOfMemoryError e) {
                logger.warn("\u5185\u5b58\u4e0d\u8db3\uff0c\u964d\u7ea7\u5230\u6d41\u5f0f\u5904\u7406: \u5757 {}", (Object)this.chunkIndex);
                return this.calculateHashStreaming();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChunkHashResult calculateHashMapped() throws Exception {
            XXHash64 hasher = this.factory.hash64();
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.start, this.size);
            try {
                long hash;
                if (buffer.hasArray()) {
                    hash = hasher.hash(buffer.array(), buffer.arrayOffset(), (int)this.size, 0L);
                } else {
                    int toRead;
                    hash = 0L;
                    int bufferSize = Math.min(0x100000, (int)this.size);
                    byte[] tempBuffer = new byte[bufferSize];
                    for (int remaining = (int)this.size; remaining > 0; remaining -= toRead) {
                        toRead = Math.min(bufferSize, remaining);
                        buffer.get(tempBuffer, 0, toRead);
                        hash = hasher.hash(tempBuffer, 0, toRead, hash);
                    }
                }
                ChunkHashResult chunkHashResult = new ChunkHashResult(this.chunkIndex, hash);
                return chunkHashResult;
            }
            finally {
                if (buffer.isDirect()) {
                    try {
                        Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        cleanerMethod.setAccessible(true);
                        Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                            cleanMethod.invoke(cleaner, new Object[0]);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private ChunkHashResult calculateHashStreaming() throws Exception {
            XXHash64 hasher = this.factory.hash64();
            try (RandomAccessFile raf = new RandomAccessFile(this.filePath, "r");){
                int toRead;
                int bytesRead;
                raf.seek(this.start);
                byte[] buffer = new byte[65536];
                long hash = 0L;
                for (long remaining = this.size; remaining > 0L && (bytesRead = raf.read(buffer, 0, toRead = (int)Math.min((long)buffer.length, remaining))) > 0; remaining -= (long)bytesRead) {
                    hash = hasher.hash(buffer, 0, bytesRead, hash);
                }
                ChunkHashResult chunkHashResult = new ChunkHashResult(this.chunkIndex, hash);
                return chunkHashResult;
            }
        }
    }

    private static class ChunkHashResult {
        final int chunkIndex;
        final long hash;

        ChunkHashResult(int chunkIndex, long hash) {
            this.chunkIndex = chunkIndex;
            this.hash = hash;
        }
    }
}

