/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class ParallelFolderStatsUtil {
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;

    public static FolderStats calculate_stats_parallel_stream(String folder_path) {
        long start_time = System.currentTimeMillis();
        Path path = Paths.get(folder_path, new String[0]);
        try {
            AtomicLong total_size = new AtomicLong(0L);
            AtomicInteger file_count = new AtomicInteger(0);
            AtomicInteger folder_count = new AtomicInteger(0);
            ((Stream)Files.walk(path, new FileVisitOption[0]).parallel()).forEach(p -> {
                try {
                    BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                    if (attrs.isRegularFile()) {
                        total_size.addAndGet(attrs.size());
                        file_count.incrementAndGet();
                    } else if (attrs.isDirectory() && !p.equals(path)) {
                        folder_count.incrementAndGet();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            long elapsed = System.currentTimeMillis() - start_time;
            return new FolderStats(total_size.get(), file_count.get(), folder_count.get(), elapsed);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8ba1\u7b97\u6587\u4ef6\u5939\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static FolderStats calculate_stats_thread_pool(String folder_path) {
        long start_time = System.currentTimeMillis();
        final Path path = Paths.get(folder_path, new String[0]);
        ForkJoinPool executor = ForkJoinPool.commonPool();
        final AtomicLong total_size = new AtomicLong(0L);
        final AtomicInteger file_count = new AtomicInteger(0);
        final AtomicInteger folder_count = new AtomicInteger(0);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    total_size.addAndGet(attrs.size());
                    file_count.incrementAndGet();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(path)) {
                        folder_count.incrementAndGet();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            long elapsed = System.currentTimeMillis() - start_time;
            return new FolderStats(total_size.get(), file_count.get(), folder_count.get(), elapsed);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8ba1\u7b97\u6587\u4ef6\u5939\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static FolderStats calculate_stats_nio2_batch(String folder_path) {
        FolderStats folderStats;
        block9: {
            long start_time = System.currentTimeMillis();
            Path path = Paths.get(folder_path, new String[0]);
            AtomicLong total_size = new AtomicLong(0L);
            AtomicInteger file_count = new AtomicInteger(0);
            AtomicInteger folder_count = new AtomicInteger(0);
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            try {
                CompletableFuture[] futures = new CompletableFuture[THREAD_POOL_SIZE];
                LinkedBlockingQueue path_queue = new LinkedBlockingQueue();
                for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
                    futures[i] = CompletableFuture.runAsync(() -> {
                        try {
                            Path p;
                            while ((p = (Path)path_queue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                                ParallelFolderStatsUtil.process_path_recursive(p, total_size, file_count, folder_count, path_queue);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
                stream.forEach(path_queue::offer);
                CompletableFuture.allOf(futures).join();
                long elapsed = System.currentTimeMillis() - start_time;
                folderStats = new FolderStats(total_size.get(), file_count.get(), folder_count.get(), elapsed);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("\u8ba1\u7b97\u6587\u4ef6\u5939\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
                }
            }
            stream.close();
        }
        return folderStats;
    }

    private static void process_path_recursive(Path path, AtomicLong total_size, AtomicInteger file_count, AtomicInteger folder_count, BlockingQueue<Path> path_queue) {
        block11: {
            try {
                BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isRegularFile()) {
                    total_size.addAndGet(attrs.size());
                    file_count.incrementAndGet();
                    break block11;
                }
                if (!attrs.isDirectory()) break block11;
                folder_count.incrementAndGet();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    stream.forEach(path_queue::offer);
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    public static class FolderStats {
        private final long total_size;
        private final int file_count;
        private final int folder_count;
        private final long elapsed_time_ms;

        public FolderStats(long total_size, int file_count, int folder_count, long elapsed_time_ms) {
            this.total_size = total_size;
            this.file_count = file_count;
            this.folder_count = folder_count;
            this.elapsed_time_ms = elapsed_time_ms;
        }

        public long getTotalSize() {
            return this.total_size;
        }

        public int getFileCount() {
            return this.file_count;
        }

        public int getFolderCount() {
            return this.folder_count;
        }

        public long getElapsedTimeMs() {
            return this.elapsed_time_ms;
        }

        public String getFormattedSize() {
            return ParallelFolderStatsUtil.formatBytes(this.total_size);
        }

        public String toString() {
            return String.format("\u7edf\u8ba1\u7ed3\u679c: %s, %d \u4e2a\u6587\u4ef6, %d \u4e2a\u6587\u4ef6\u5939, \u8017\u65f6: %d ms", this.getFormattedSize(), this.file_count, this.folder_count, this.elapsed_time_ms);
        }
    }
}

