/*
 * Decompiled with CFR 0.152.
 */
package com.file.netty.utils;

import com.file.netty.protocol.FileEntryInfo;
import com.file.netty.utils.FileTransferUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferStrategyDecider {
    private static final Logger logger = LoggerFactory.getLogger(TransferStrategyDecider.class);
    public static final int MIN_BATCH_FILES = 5;
    public static final int MAX_BATCH_FILES = 1000;
    public static final long TARGET_BATCH_SIZE = 0x6400000L;

    public static TransferDecision decideTransferStrategy(List<FileEntryInfo> allFiles) {
        if (allFiles == null || allFiles.isEmpty()) {
            return new TransferDecision(false, null, null, "\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        int totalFileCount = allFiles.size();
        long totalSize = allFiles.stream().mapToLong(FileEntryInfo::getFileSize).sum();
        logger.info("\ud83d\udcca \u6587\u4ef6\u5206\u6790: \u603b\u5171 {} \u4e2a\u6587\u4ef6, \u603b\u5927\u5c0f {}", (Object)totalFileCount, (Object)FileTransferUtils.formatBytes(totalSize));
        if (totalFileCount >= 5) {
            String reason = String.format("\u6587\u4ef6\u6570\u91cf\u8db3\u591f(%d\u2265%d)\uff0c\u4f7f\u7528\u6279\u6b21\u4f20\u8f93\uff0c\u81ea\u52a8\u5206\u7ec4\u6210\u591a\u4e2a\u6279\u6b21\u5305", totalFileCount, 5);
            logger.info("\ud83d\ude80 \u51b3\u7b56\u7ed3\u679c: {}", (Object)reason);
            logger.info("   - \u6279\u6b21\u4f20\u8f93: {} \u4e2a\u6587\u4ef6, {} (\u5c06\u5206\u7ec4\u4e3a\u591a\u4e2a100MB\u6279\u6b21\u5305)", (Object)totalFileCount, (Object)FileTransferUtils.formatBytes(totalSize));
            return new TransferDecision(true, allFiles, new ArrayList<FileEntryInfo>(), reason);
        }
        String reason = String.format("\u6587\u4ef6\u6570\u91cf\u592a\u5c11(%d<%d)\uff0c\u4f7f\u7528\u5355\u6587\u4ef6\u4f20\u8f93\u66f4\u9ad8\u6548", totalFileCount, 5);
        logger.info("\ud83d\udcc4 \u51b3\u7b56\u7ed3\u679c: {}", (Object)reason);
        logger.info("   - \u5355\u6587\u4ef6\u4f20\u8f93: {} \u4e2a\u6587\u4ef6, {}", (Object)totalFileCount, (Object)FileTransferUtils.formatBytes(totalSize));
        return new TransferDecision(false, new ArrayList<FileEntryInfo>(), allFiles, reason);
    }

    public static BatchGroupResult createBatchGroupsWithRemainder(List<FileEntryInfo> allFiles) {
        int i;
        ArrayList<List<FileEntryInfo>> batches = new ArrayList<List<FileEntryInfo>>();
        ArrayList<FileEntryInfo> unbatchableFiles = new ArrayList<FileEntryInfo>();
        if (allFiles == null || allFiles.isEmpty()) {
            return new BatchGroupResult(batches, unbatchableFiles);
        }
        ArrayList<FileEntryInfo> sortedFiles = new ArrayList<FileEntryInfo>(allFiles);
        sortedFiles.sort((a, b) -> Long.compare(a.getFileSize(), b.getFileSize()));
        ArrayList<FileEntryInfo> currentBatch = new ArrayList<FileEntryInfo>();
        long currentBatchSize = 0L;
        int processedIndex = 0;
        for (i = 0; i < sortedFiles.size(); ++i) {
            FileEntryInfo file = (FileEntryInfo)sortedFiles.get(i);
            processedIndex = i;
            long fileSize = file.getFileSize();
            boolean shouldStartNewBatch = false;
            if (!currentBatch.isEmpty()) {
                if (currentBatch.size() >= 1000) {
                    shouldStartNewBatch = true;
                } else if (currentBatchSize + fileSize > 0x6400000L) {
                    shouldStartNewBatch = true;
                } else if (currentBatchSize >= 0x6400000L && currentBatch.size() >= 5) {
                    shouldStartNewBatch = true;
                }
            }
            if (shouldStartNewBatch) {
                if (currentBatch.size() >= 5) {
                    batches.add(new ArrayList(currentBatch));
                    logger.debug("\u5b8c\u6210\u6279\u6b21: {} \u4e2a\u6587\u4ef6, \u603b\u5927\u5c0f: {}", (Object)currentBatch.size(), (Object)FileTransferUtils.formatBytes(currentBatchSize));
                } else {
                    unbatchableFiles.addAll(currentBatch);
                    logger.debug("\u6279\u6b21\u6587\u4ef6\u6570\u4e0d\u8db3({}<{})\uff0c\u8f6c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93", (Object)currentBatch.size(), (Object)5);
                }
                List<FileEntryInfo> remainingFiles = sortedFiles.subList(i, sortedFiles.size());
                if (!TransferStrategyDecider.canFormValidBatch(remainingFiles)) {
                    unbatchableFiles.addAll(remainingFiles);
                    logger.info("\u26a0\ufe0f \u5269\u4f59 {} \u4e2a\u6587\u4ef6\u65e0\u6cd5\u5f62\u6210\u6709\u6548\u6279\u6b21\uff08\u6700\u5c0f5\u4e2a\u6587\u4ef6\u7ec4\u5408\u4e5f\u8d85\u8fc7100MB\uff09\uff0c\u5168\u90e8\u8f6c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93", (Object)remainingFiles.size());
                    break;
                }
                currentBatch.clear();
                currentBatchSize = 0L;
            }
            currentBatch.add(file);
            currentBatchSize += fileSize;
        }
        if (!currentBatch.isEmpty()) {
            if (currentBatch.size() >= 5 && currentBatchSize <= 0x6400000L) {
                batches.add(currentBatch);
                logger.debug("\u5b8c\u6210\u6700\u540e\u6279\u6b21: {} \u4e2a\u6587\u4ef6, \u603b\u5927\u5c0f: {}", (Object)currentBatch.size(), (Object)FileTransferUtils.formatBytes(currentBatchSize));
            } else if (!batches.isEmpty() && currentBatch.size() < 5) {
                List lastBatch = (List)batches.get(batches.size() - 1);
                long lastBatchSize = lastBatch.stream().mapToLong(FileEntryInfo::getFileSize).sum();
                if (lastBatch.size() + currentBatch.size() <= 1000 && lastBatchSize + currentBatchSize <= 0x6400000L) {
                    lastBatch.addAll(currentBatch);
                    logger.debug("\u5408\u5e76\u6700\u540e {} \u4e2a\u6587\u4ef6\u5230\u524d\u4e00\u6279\u6b21\uff0c\u524d\u4e00\u6279\u6b21\u73b0\u6709 {} \u4e2a\u6587\u4ef6", (Object)currentBatch.size(), (Object)lastBatch.size());
                } else {
                    unbatchableFiles.addAll(currentBatch);
                    logger.warn("\u26a0\ufe0f \u6700\u540e {} \u4e2a\u6587\u4ef6\u65e0\u6cd5\u5408\u5e76\u5230\u524d\u4e00\u6279\u6b21\uff0c\u5c06\u4f5c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93", (Object)currentBatch.size());
                }
            } else {
                unbatchableFiles.addAll(currentBatch);
                String reason = currentBatch.size() < 5 ? "\u6570\u91cf\u4e0d\u8db3" : "\u8d85\u8fc7100MB\u9650\u5236";
                logger.warn("\u26a0\ufe0f \u6700\u540e {} \u4e2a\u6587\u4ef6{}\uff0c\u5c06\u4f5c\u4e3a\u5355\u6587\u4ef6\u4f20\u8f93", (Object)currentBatch.size(), (Object)reason);
            }
        }
        logger.info("\ud83d\udce6 \u667a\u80fd\u5206\u7ec4\u5b8c\u6210: {} \u4e2a\u6279\u6b21\u5305, {} \u4e2a\u6587\u4ef6\u9700\u5355\u72ec\u4f20\u8f93", (Object)batches.size(), (Object)unbatchableFiles.size());
        for (i = 0; i < batches.size(); ++i) {
            List batch = (List)batches.get(i);
            long batchSize = batch.stream().mapToLong(FileEntryInfo::getFileSize).sum();
            logger.info("   \u6279\u6b21{}: {} \u4e2a\u6587\u4ef6, {}", i + 1, batch.size(), FileTransferUtils.formatBytes(batchSize));
        }
        if (!unbatchableFiles.isEmpty()) {
            long unbatchableSize = unbatchableFiles.stream().mapToLong(FileEntryInfo::getFileSize).sum();
            logger.info("   \u5355\u6587\u4ef6\u4f20\u8f93: {} \u4e2a\u6587\u4ef6, {}", (Object)unbatchableFiles.size(), (Object)FileTransferUtils.formatBytes(unbatchableSize));
        }
        return new BatchGroupResult(batches, unbatchableFiles);
    }

    private static boolean canFormValidBatch(List<FileEntryInfo> files) {
        boolean canForm;
        if (files.size() < 5) {
            return false;
        }
        long smallestFiveSize = files.stream().limit(5L).mapToLong(FileEntryInfo::getFileSize).sum();
        boolean bl = canForm = smallestFiveSize <= 0x6400000L;
        if (!canForm) {
            logger.debug("\u65e0\u6cd5\u5f62\u6210\u6709\u6548\u6279\u6b21\uff1a\u6700\u5c0f5\u4e2a\u6587\u4ef6\u5df2\u8d85\u8fc7100MB ({})", (Object)FileTransferUtils.formatBytes(smallestFiveSize));
        }
        return canForm;
    }

    @Deprecated
    public static List<List<FileEntryInfo>> createBatchGroups(List<FileEntryInfo> allFiles) {
        return TransferStrategyDecider.createBatchGroupsWithRemainder(allFiles).getBatchGroups();
    }

    public static class TransferDecision {
        private final boolean useBatchTransfer;
        private final List<FileEntryInfo> batchFiles;
        private final List<FileEntryInfo> singleFiles;
        private final String reason;

        public TransferDecision(boolean useBatchTransfer, List<FileEntryInfo> batchFiles, List<FileEntryInfo> singleFiles, String reason) {
            this.useBatchTransfer = useBatchTransfer;
            this.batchFiles = batchFiles != null ? batchFiles : new ArrayList();
            this.singleFiles = singleFiles != null ? singleFiles : new ArrayList();
            this.reason = reason;
        }

        public boolean shouldUseBatchTransfer() {
            return this.useBatchTransfer;
        }

        public List<FileEntryInfo> getBatchFiles() {
            return this.batchFiles;
        }

        public List<FileEntryInfo> getSingleFiles() {
            return this.singleFiles;
        }

        public String getReason() {
            return this.reason;
        }

        public int getTotalFiles() {
            return this.batchFiles.size() + this.singleFiles.size();
        }

        public long getTotalBatchSize() {
            return this.batchFiles.stream().mapToLong(FileEntryInfo::getFileSize).sum();
        }

        public long getTotalSingleSize() {
            return this.singleFiles.stream().mapToLong(FileEntryInfo::getFileSize).sum();
        }

        public String toString() {
            if (this.useBatchTransfer) {
                return String.format("\u6279\u6b21\u4f20\u8f93\u7b56\u7565: %d\u4e2a\u6587\u4ef6(\u6279\u6b21\u4f20\u8f93) - %s", this.batchFiles.size(), this.reason);
            }
            return String.format("\u5355\u6587\u4ef6\u4f20\u8f93\u7b56\u7565: %d\u4e2a\u6587\u4ef6(\u5168\u90e8\u5355\u72ec\u4f20\u8f93) - %s", this.getTotalFiles(), this.reason);
        }
    }

    public static class BatchGroupResult {
        private final List<List<FileEntryInfo>> batchGroups;
        private final List<FileEntryInfo> unbatchableFiles;

        public BatchGroupResult(List<List<FileEntryInfo>> batchGroups, List<FileEntryInfo> unbatchableFiles) {
            this.batchGroups = batchGroups;
            this.unbatchableFiles = unbatchableFiles;
        }

        public List<List<FileEntryInfo>> getBatchGroups() {
            return this.batchGroups;
        }

        public List<FileEntryInfo> getUnbatchableFiles() {
            return this.unbatchableFiles;
        }

        public int getTotalBatchFiles() {
            return this.batchGroups.stream().mapToInt(List::size).sum();
        }
    }
}

