/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Test02_BroadcastDiscovery {
    private static final int BROADCAST_PORT = 8901;
    private static final int BROADCAST_INTERVAL_MS = 10000;
    private static final int DEVICE_TIMEOUT_MS = 30000;
    private static final int SOCKET_TIMEOUT_MS = 1000;
    private final String deviceId;
    private final String deviceName;
    private final int tcpServicePort;
    private final Map<String, String> additionalInfo;
    private DatagramSocket broadcastSocket;
    private Thread receiverThread;
    private ScheduledExecutorService broadcastScheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, DiscoveredDevice> discoveredDevices = new ConcurrentHashMap<String, DiscoveredDevice>();
    private final List<DeviceDiscoveryListener> listeners = new CopyOnWriteArrayList<DeviceDiscoveryListener>();

    public Test02_BroadcastDiscovery(String deviceName, int tcpServicePort) {
        this(UUID.randomUUID().toString(), deviceName, tcpServicePort, new HashMap<String, String>());
    }

    public Test02_BroadcastDiscovery(String deviceId, String deviceName, int tcpServicePort, Map<String, String> additionalInfo) {
        this.deviceId = deviceId;
        this.deviceName = deviceName;
        this.tcpServicePort = tcpServicePort;
        this.additionalInfo = additionalInfo;
    }

    public void addDeviceDiscoveryListener(DeviceDiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public void removeDeviceDiscoveryListener(DeviceDiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        block4: {
            if (this.running.getAndSet(true)) {
                return;
            }
            try {
                this.broadcastSocket = new DatagramSocket(8901);
                this.broadcastSocket.setBroadcast(true);
                this.broadcastSocket.setSoTimeout(1000);
                this.receiverThread = new Thread(this::receiveLoop, "BroadcastReceiver");
                this.receiverThread.setDaemon(true);
                this.receiverThread.start();
                this.broadcastScheduler = Executors.newSingleThreadScheduledExecutor();
                this.broadcastScheduler.scheduleAtFixedRate(this::broadcastDeviceInfo, 0L, 10000L, TimeUnit.MILLISECONDS);
                this.broadcastScheduler.scheduleAtFixedRate(this::cleanupExpiredDevices, 30000L, 30000L, TimeUnit.MILLISECONDS);
                System.out.println("\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1\u5df2\u542f\u52a8\uff0c\u8bbe\u5907ID: " + this.deviceId);
            }
            catch (Exception e) {
                this.running.set(false);
                System.err.println("\u542f\u52a8\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
                if (this.broadcastSocket != null && !this.broadcastSocket.isClosed()) {
                    this.broadcastSocket.close();
                }
                if (this.broadcastScheduler == null) break block4;
                this.broadcastScheduler.shutdownNow();
            }
        }
    }

    public void stop() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.broadcastScheduler != null) {
            this.broadcastScheduler.shutdownNow();
        }
        if (this.broadcastSocket != null && !this.broadcastSocket.isClosed()) {
            this.broadcastSocket.close();
        }
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
        }
        System.out.println("\u5e7f\u64ad\u53d1\u73b0\u670d\u52a1\u5df2\u505c\u6b62");
    }

    public void refreshDiscovery() {
        if (this.running.get()) {
            this.broadcastDeviceInfo();
        }
    }

    public List<DiscoveredDevice> getDiscoveredDevices() {
        return new ArrayList<DiscoveredDevice>(this.discoveredDevices.values());
    }

    public DiscoveredDevice getDevice(String deviceId) {
        return this.discoveredDevices.get(deviceId);
    }

    private void broadcastDeviceInfo() {
        try {
            List<DiscoveredDevice.NetworkInterface> interfaces = this.collectNetworkInterfaces();
            DiscoveredDevice localDevice = new DiscoveredDevice();
            localDevice.setDeviceId(this.deviceId);
            localDevice.setDeviceName(this.deviceName);
            localDevice.setNetworkInterfaces(interfaces);
            localDevice.setTcpServicePort(this.tcpServicePort);
            localDevice.setAdditionalInfo(this.additionalInfo);
            localDevice.setLastUpdateTime(System.currentTimeMillis());
            String message = this.serializeDeviceInfo(localDevice);
            byte[] buffer = message.getBytes();
            InetAddress broadcastAddress = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, broadcastAddress, 8901);
            this.broadcastSocket.send(packet);
            for (DiscoveredDevice.NetworkInterface iface : interfaces) {
                try {
                    String broadcastIp = this.getBroadcastAddress(iface.getIpAddress(), iface.getSubnetMask());
                    if (broadcastIp == null || broadcastIp.equals("255.255.255.255")) continue;
                    packet = new DatagramPacket(buffer, buffer.length, InetAddress.getByName(broadcastIp), 8901);
                    this.broadcastSocket.send(packet);
                }
                catch (Exception exception) {}
            }
            System.out.println("\u5df2\u5e7f\u64ad\u8bbe\u5907\u4fe1\u606f\u5230\u7f51\u7edc");
        }
        catch (Exception e) {
            System.err.println("\u5e7f\u64ad\u8bbe\u5907\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void receiveLoop() {
        byte[] buffer = new byte[8192];
        while (this.running.get()) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    this.broadcastSocket.receive(packet);
                    String message = new String(packet.getData(), 0, packet.getLength());
                    String sourceIp = packet.getAddress().getHostAddress();
                    this.processMessage(message, sourceIp);
                    continue;
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (IOException e) {
                    if (this.running.get()) {
                        System.err.println("\u63a5\u6536\u5e7f\u64ad\u6d88\u606f\u9519\u8bef: " + e.getMessage());
                    }
                    if (!this.broadcastSocket.isClosed()) continue;
                }
            }
            catch (Exception e) {
                if (!this.running.get()) break;
                System.err.println("\u5e7f\u64ad\u63a5\u6536\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
                e.printStackTrace();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {}
            }
            break;
        }
        System.out.println("\u5e7f\u64ad\u63a5\u6536\u7ebf\u7a0b\u5df2\u9000\u51fa");
    }

    private void processMessage(String message, String sourceIp) {
        try {
            DiscoveredDevice device = this.deserializeDeviceInfo(message);
            if (this.deviceId.equals(device.getDeviceId())) {
                return;
            }
            device.setLastUpdateTime(System.currentTimeMillis());
            boolean isNewDevice = !this.discoveredDevices.containsKey(device.getDeviceId());
            this.discoveredDevices.put(device.getDeviceId(), device);
            if (isNewDevice) {
                for (DeviceDiscoveryListener listener : this.listeners) {
                    try {
                        listener.onDeviceDiscovered(device, sourceIp);
                    }
                    catch (Exception e) {
                        System.err.println("\u8bbe\u5907\u53d1\u73b0\u76d1\u542c\u5668\u5f02\u5e38: " + e.getMessage());
                    }
                }
                System.out.println("\u53d1\u73b0\u65b0\u8bbe\u5907: " + device.getDeviceName() + " (ID: " + device.getDeviceId() + ", IP: " + device.getAllIpAddresses() + ")");
            } else {
                for (DeviceDiscoveryListener listener : this.listeners) {
                    try {
                        listener.onDeviceUpdated(device, sourceIp);
                    }
                    catch (Exception e) {
                        System.err.println("\u8bbe\u5907\u66f4\u65b0\u76d1\u542c\u5668\u5f02\u5e38: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u5e7f\u64ad\u6d88\u606f\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void cleanupExpiredDevices() {
        long now = System.currentTimeMillis();
        HashSet<String> expiredDeviceIds = new HashSet<String>();
        for (DiscoveredDevice device : this.discoveredDevices.values()) {
            if (now - device.getLastUpdateTime() <= 30000L) continue;
            expiredDeviceIds.add(device.getDeviceId());
        }
        for (String deviceId : expiredDeviceIds) {
            DiscoveredDevice device = this.discoveredDevices.remove(deviceId);
            if (device == null) continue;
            for (DeviceDiscoveryListener listener : this.listeners) {
                try {
                    listener.onDeviceOffline(device);
                }
                catch (Exception e) {
                    System.err.println("\u8bbe\u5907\u79bb\u7ebf\u76d1\u542c\u5668\u5f02\u5e38: " + e.getMessage());
                }
            }
            System.out.println("\u8bbe\u5907\u79bb\u7ebf: " + device.getDeviceName() + " (ID: " + device.getDeviceId() + ")");
        }
    }

    private List<DiscoveredDevice.NetworkInterface> collectNetworkInterfaces() {
        ArrayList<DiscoveredDevice.NetworkInterface> result = new ArrayList<DiscoveredDevice.NetworkInterface>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = netInterfaces.nextElement();
                if (!netInterface.isUp() || netInterface.isLoopback() || netInterface.isVirtual()) continue;
                byte[] hardwareAddress = netInterface.getHardwareAddress();
                String macAddress = hardwareAddress != null ? this.formatMacAddress(hardwareAddress) : null;
                int priority = this.calculateInterfacePriority(netInterface);
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    String ipAddress = address.getHostAddress();
                    String subnetMask = this.getSubnetMask(netInterface);
                    DiscoveredDevice.NetworkInterface iface = new DiscoveredDevice.NetworkInterface();
                    iface.setName(netInterface.getName());
                    iface.setIpAddress(ipAddress);
                    iface.setMacAddress(macAddress);
                    iface.setPriority(priority);
                    iface.setSubnetMask(subnetMask);
                    result.add(iface);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u7f51\u7edc\u63a5\u53e3\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private String formatMacAddress(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
        }
        return sb.toString();
    }

    private int calculateInterfacePriority(NetworkInterface netInterface) {
        String name = netInterface.getName().toLowerCase();
        if (name.startsWith("eth") || name.startsWith("en") || name.contains("ethernet")) {
            return 10;
        }
        if (name.startsWith("wlan") || name.contains("wireless") || name.contains("wifi")) {
            return 20;
        }
        if (name.contains("tun") || name.contains("tap") || name.contains("vpn")) {
            return 50;
        }
        if (name.contains("virt") || name.contains("docker") || name.contains("vmnet")) {
            return 40;
        }
        return 30;
    }

    private String getSubnetMask(NetworkInterface netInterface) {
        try {
            List<InterfaceAddress> interfaceAddresses = netInterface.getInterfaceAddresses();
            for (InterfaceAddress address : interfaceAddresses) {
                if (!(address.getAddress() instanceof Inet4Address)) continue;
                short prefixLength = address.getNetworkPrefixLength();
                return this.prefixLengthToSubnetMask(prefixLength);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "255.255.255.0";
    }

    private String prefixLengthToSubnetMask(int length) {
        int mask = -1 << 32 - length;
        return String.format("%d.%d.%d.%d", mask >>> 24 & 0xFF, mask >>> 16 & 0xFF, mask >>> 8 & 0xFF, mask & 0xFF);
    }

    private String getBroadcastAddress(String ipAddress, String subnetMask) {
        try {
            byte[] ipBytes = InetAddress.getByName(ipAddress).getAddress();
            byte[] maskBytes = InetAddress.getByName(subnetMask).getAddress();
            byte[] broadcastBytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                broadcastBytes[i] = (byte)(ipBytes[i] | ~maskBytes[i]);
            }
            return InetAddress.getByAddress(broadcastBytes).getHostAddress();
        }
        catch (Exception e) {
            return "255.255.255.255";
        }
    }

    private String serializeDeviceInfo(DiscoveredDevice device) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"deviceId\":\"").append(this.escape(device.getDeviceId())).append("\",");
        sb.append("\"deviceName\":\"").append(this.escape(device.getDeviceName())).append("\",");
        sb.append("\"tcpServicePort\":").append(device.getTcpServicePort()).append(",");
        sb.append("\"networkInterfaces\":[");
        for (int i = 0; i < device.getNetworkInterfaces().size(); ++i) {
            DiscoveredDevice.NetworkInterface iface = device.getNetworkInterfaces().get(i);
            sb.append("{");
            sb.append("\"name\":\"").append(this.escape(iface.getName())).append("\",");
            sb.append("\"ipAddress\":\"").append(this.escape(iface.getIpAddress())).append("\",");
            if (iface.getMacAddress() != null) {
                sb.append("\"macAddress\":\"").append(this.escape(iface.getMacAddress())).append("\",");
            }
            sb.append("\"priority\":").append(iface.getPriority());
            if (iface.getSubnetMask() != null) {
                sb.append(",\"subnetMask\":\"").append(this.escape(iface.getSubnetMask())).append("\"");
            }
            sb.append("}");
            if (i >= device.getNetworkInterfaces().size() - 1) continue;
            sb.append(",");
        }
        sb.append("],");
        sb.append("\"additionalInfo\":{");
        int idx = 0;
        for (Map.Entry<String, String> entry : device.getAdditionalInfo().entrySet()) {
            sb.append("\"").append(this.escape(entry.getKey())).append("\":\"").append(this.escape(entry.getValue())).append("\"");
            if (idx < device.getAdditionalInfo().size() - 1) {
                sb.append(",");
            }
            ++idx;
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    private DiscoveredDevice deserializeDeviceInfo(String json) {
        DiscoveredDevice device = new DiscoveredDevice();
        try {
            String additionalInfoJson;
            String interfacesJson;
            String tcpPortRegex;
            String deviceNameRegex;
            String deviceIdRegex = "\"deviceId\":\"([^\"]+)\"";
            Pattern pattern = Pattern.compile(deviceIdRegex);
            Matcher matcher = pattern.matcher(json);
            if (matcher.find()) {
                device.setDeviceId(matcher.group(1));
            }
            if ((matcher = (pattern = Pattern.compile(deviceNameRegex = "\"deviceName\":\"([^\"]+)\"")).matcher(json)).find()) {
                device.setDeviceName(matcher.group(1));
            }
            if ((matcher = (pattern = Pattern.compile(tcpPortRegex = "\"tcpServicePort\":([0-9]+)")).matcher(json)).find()) {
                device.setTcpServicePort(Integer.parseInt(matcher.group(1)));
            }
            if ((interfacesJson = this.extractJsonArray(json, "networkInterfaces")) != null) {
                ArrayList<DiscoveredDevice.NetworkInterface> interfaces = new ArrayList<DiscoveredDevice.NetworkInterface>();
                List<String> interfaceObjs = this.splitJsonArray(interfacesJson);
                for (String ifaceJson : interfaceObjs) {
                    DiscoveredDevice.NetworkInterface iface = new DiscoveredDevice.NetworkInterface();
                    pattern = Pattern.compile("\"name\":\"([^\"]+)\"");
                    matcher = pattern.matcher(ifaceJson);
                    if (matcher.find()) {
                        iface.setName(matcher.group(1));
                    }
                    if ((matcher = (pattern = Pattern.compile("\"ipAddress\":\"([^\"]+)\"")).matcher(ifaceJson)).find()) {
                        iface.setIpAddress(matcher.group(1));
                    }
                    if ((matcher = (pattern = Pattern.compile("\"macAddress\":\"([^\"]+)\"")).matcher(ifaceJson)).find()) {
                        iface.setMacAddress(matcher.group(1));
                    }
                    if ((matcher = (pattern = Pattern.compile("\"priority\":([0-9]+)")).matcher(ifaceJson)).find()) {
                        iface.setPriority(Integer.parseInt(matcher.group(1)));
                    }
                    if ((matcher = (pattern = Pattern.compile("\"subnetMask\":\"([^\"]+)\"")).matcher(ifaceJson)).find()) {
                        iface.setSubnetMask(matcher.group(1));
                    }
                    interfaces.add(iface);
                }
                device.setNetworkInterfaces(interfaces);
            }
            if ((additionalInfoJson = this.extractJsonObject(json, "additionalInfo")) != null) {
                HashMap<String, String> additionalInfo = new HashMap<String, String>();
                pattern = Pattern.compile("\"([^\"]+)\":\"([^\"]*)\"");
                matcher = pattern.matcher(additionalInfoJson);
                while (matcher.find()) {
                    additionalInfo.put(matcher.group(1), matcher.group(2));
                }
                device.setAdditionalInfo(additionalInfo);
            }
        }
        catch (Exception e) {
            System.err.println("\u89e3\u6790\u8bbe\u5907\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
        return device;
    }

    private String extractJsonArray(String json, String arrayName) {
        int end;
        int start = json.indexOf("\"" + arrayName + "\":[");
        if (start == -1) {
            return null;
        }
        if ((start = json.indexOf(91, start)) == -1) {
            return null;
        }
        int depth = 1;
        for (end = start + 1; depth > 0 && end < json.length(); ++end) {
            char c = json.charAt(end);
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c != ']') continue;
            --depth;
        }
        if (depth != 0) {
            return null;
        }
        return json.substring(start + 1, end - 1);
    }

    private String extractJsonObject(String json, String objectName) {
        int end;
        int start = json.indexOf("\"" + objectName + "\":{");
        if (start == -1) {
            return null;
        }
        if ((start = json.indexOf(123, start)) == -1) {
            return null;
        }
        int depth = 1;
        for (end = start + 1; depth > 0 && end < json.length(); ++end) {
            char c = json.charAt(end);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}') continue;
            --depth;
        }
        if (depth != 0) {
            return null;
        }
        return json.substring(start + 1, end - 1);
    }

    private List<String> splitJsonArray(String arrayJson) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int depth = 0;
        for (int i = 0; i < arrayJson.length(); ++i) {
            char c = arrayJson.charAt(i);
            if (c == '{') {
                if (depth == 0) {
                    start = i;
                }
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            result.add(arrayJson.substring(start, i + 1));
        }
        return result;
    }

    private String escape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static void main(String[] args) {
        try {
            String deviceName = "Device-" + new Random().nextInt(1000);
            int tcpPort = 8080;
            if (args.length > 0) {
                deviceName = args[0];
            }
            if (args.length > 1) {
                try {
                    tcpPort = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("\u65e0\u6548\u7684\u7aef\u53e3\u53f7: " + args[1]);
                }
            }
            Test02_BroadcastDiscovery discovery = new Test02_BroadcastDiscovery(deviceName, tcpPort);
            discovery.addDeviceDiscoveryListener(new DeviceDiscoveryListener(){

                @Override
                public void onDeviceDiscovered(DiscoveredDevice device, String sourceIp) {
                    System.out.println("\u53d1\u73b0\u65b0\u8bbe\u5907: " + device.getDeviceName());
                    System.out.println("  \u8bbe\u5907ID: " + device.getDeviceId());
                    System.out.println("  IP\u5730\u5740\u5217\u8868: " + device.getAllIpAddresses());
                    System.out.println("  TCP\u670d\u52a1\u7aef\u53e3: " + device.getTcpServicePort());
                }

                @Override
                public void onDeviceUpdated(DiscoveredDevice device, String sourceIp) {
                    System.out.println("\u8bbe\u5907\u66f4\u65b0: " + device.getDeviceName());
                    System.out.println("  IP\u5730\u5740\u5217\u8868: " + device.getAllIpAddresses());
                }

                @Override
                public void onDeviceOffline(DiscoveredDevice device) {
                    System.out.println("\u8bbe\u5907\u79bb\u7ebf: " + device.getDeviceName());
                }
            });
            discovery.start();
            System.out.println("\u8bbe\u5907 '" + deviceName + "' \u5df2\u542f\u52a8\uff0cTCP\u7aef\u53e3: " + tcpPort);
            ConnectionManager connectionManager = new ConnectionManager(5000);
            Scanner scanner = new Scanner(System.in);
            System.out.println("\n\u547d\u4ee4: list, connect <id>, refresh, exit");
            boolean running = true;
            while (running) {
                System.out.print("> ");
                String command = scanner.nextLine().trim();
                if (command.equals("list")) {
                    List<DiscoveredDevice> devices = discovery.getDiscoveredDevices();
                    System.out.println("\u53d1\u73b0\u7684\u8bbe\u5907 (" + devices.size() + "):");
                    for (DiscoveredDevice device : devices) {
                        System.out.println(device.getDeviceId() + ": " + device.getDeviceName());
                        System.out.println("  IP\u5730\u5740: " + device.getAllIpAddresses());
                        System.out.println("  TCP\u7aef\u53e3: " + device.getTcpServicePort());
                    }
                    continue;
                }
                if (command.startsWith("connect ")) {
                    String deviceId = command.substring("connect ".length()).trim();
                    DiscoveredDevice device = discovery.getDevice(deviceId);
                    if (device == null) {
                        System.out.println("\u672a\u627e\u5230\u8bbe\u5907: " + deviceId);
                        continue;
                    }
                    System.out.println("\u5c1d\u8bd5\u8fde\u63a5\u5230\u8bbe\u5907: " + device.getDeviceName());
                    DiscoveredDevice localDevice = new DiscoveredDevice();
                    localDevice.setNetworkInterfaces(discovery.collectNetworkInterfaces());
                    ConnectionManager.ConnectionResult result = connectionManager.connectToDevice(localDevice, device, null);
                    if (result.isSuccess()) {
                        System.out.println("\u8fde\u63a5\u6210\u529f! " + result);
                        Socket socket = result.getSocket();
                        try {
                            OutputStream out = socket.getOutputStream();
                            String message = "Hello from " + deviceName + "!";
                            out.write(message.getBytes());
                            out.flush();
                            System.out.println("\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f: " + message);
                            InputStream in = socket.getInputStream();
                            byte[] buffer = new byte[1024];
                            int bytesRead = in.read(buffer);
                            if (bytesRead > 0) {
                                String response = new String(buffer, 0, bytesRead);
                                System.out.println("\u6536\u5230\u54cd\u5e94: " + response);
                            }
                            socket.close();
                        }
                        catch (Exception e) {
                            System.err.println("\u901a\u4fe1\u9519\u8bef: " + e.getMessage());
                        }
                        continue;
                    }
                    System.out.println("\u8fde\u63a5\u5931\u8d25: \u6240\u6709IP\u5bf9\u5747\u65e0\u6cd5\u8fde\u63a5");
                    continue;
                }
                if (command.equals("refresh")) {
                    discovery.refreshDiscovery();
                    System.out.println("\u5df2\u5237\u65b0\u8bbe\u5907\u53d1\u73b0");
                    continue;
                }
                if (command.equals("exit")) {
                    running = false;
                    continue;
                }
                if (command.isEmpty()) continue;
                System.out.println("\u672a\u77e5\u547d\u4ee4: " + command);
                System.out.println("\u53ef\u7528\u547d\u4ee4: list, connect <id>, refresh, exit");
            }
            discovery.stop();
            System.out.println("\u7a0b\u5e8f\u5df2\u9000\u51fa");
        }
        catch (Exception e) {
            System.err.println("\u7a0b\u5e8f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static class DiscoveredDevice {
        private String deviceId;
        private String deviceName;
        private List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        private int tcpServicePort;
        private Map<String, String> additionalInfo = new HashMap<String, String>();
        private long lastUpdateTime;

        public String getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public List<NetworkInterface> getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
        }

        public int getTcpServicePort() {
            return this.tcpServicePort;
        }

        public void setTcpServicePort(int tcpServicePort) {
            this.tcpServicePort = tcpServicePort;
        }

        public Map<String, String> getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setAdditionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public List<String> getAllIpAddresses() {
            ArrayList<String> result = new ArrayList<String>();
            for (NetworkInterface iface : this.networkInterfaces) {
                result.add(iface.getIpAddress());
            }
            return result;
        }

        public String getPrimaryIpAddress() {
            if (this.networkInterfaces.isEmpty()) {
                return null;
            }
            NetworkInterface primary = this.networkInterfaces.stream().min(Comparator.comparingInt(NetworkInterface::getPriority)).orElse(this.networkInterfaces.get(0));
            return primary.getIpAddress();
        }

        public String findBestMatchingIp(String targetIp) {
            for (NetworkInterface iface : this.networkInterfaces) {
                if (!targetIp.equals(iface.getIpAddress())) continue;
                return iface.getIpAddress();
            }
            for (NetworkInterface iface : this.networkInterfaces) {
                if (iface.getSubnetMask() == null || !this.isInSameSubnet(iface.getIpAddress(), targetIp, iface.getSubnetMask())) continue;
                return iface.getIpAddress();
            }
            for (NetworkInterface iface : this.networkInterfaces) {
                if (!this.isInSameSubnet(iface.getIpAddress(), targetIp, "255.255.255.0")) continue;
                return iface.getIpAddress();
            }
            for (NetworkInterface iface : this.networkInterfaces) {
                if (!this.isInSameSubnet(iface.getIpAddress(), targetIp, "255.255.0.0")) continue;
                return iface.getIpAddress();
            }
            return this.getPrimaryIpAddress();
        }

        private boolean isInSameSubnet(String ip1, String ip2, String subnetMask) {
            try {
                byte[] addr1 = InetAddress.getByName(ip1).getAddress();
                byte[] addr2 = InetAddress.getByName(ip2).getAddress();
                byte[] mask = InetAddress.getByName(subnetMask).getAddress();
                if (addr1.length != addr2.length || addr1.length != mask.length) {
                    return false;
                }
                for (int i = 0; i < addr1.length; ++i) {
                    if ((addr1[i] & mask[i]) == (addr2[i] & mask[i])) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String toString() {
            return "Device{id='" + this.deviceId + "', name='" + this.deviceName + "', interfaces=" + this.networkInterfaces + ", port=" + this.tcpServicePort + "}";
        }

        public static class NetworkInterface {
            private String name;
            private String ipAddress;
            private String macAddress;
            private int priority;
            private String subnetMask;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getIpAddress() {
                return this.ipAddress;
            }

            public void setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
            }

            public String getMacAddress() {
                return this.macAddress;
            }

            public void setMacAddress(String macAddress) {
                this.macAddress = macAddress;
            }

            public int getPriority() {
                return this.priority;
            }

            public void setPriority(int priority) {
                this.priority = priority;
            }

            public String getSubnetMask() {
                return this.subnetMask;
            }

            public void setSubnetMask(String subnetMask) {
                this.subnetMask = subnetMask;
            }

            public String toString() {
                return this.name + "(" + this.ipAddress + ")";
            }
        }
    }

    public static interface DeviceDiscoveryListener {
        public void onDeviceDiscovered(DiscoveredDevice var1, String var2);

        public void onDeviceUpdated(DiscoveredDevice var1, String var2);

        public void onDeviceOffline(DiscoveredDevice var1);
    }

    public static class ConnectionManager {
        private final int connectionTimeout;

        public ConnectionManager(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public ConnectionResult connectToDevice(DiscoveredDevice localDeviceInfo, DiscoveredDevice remoteDeviceInfo, String sourceIp) {
            List<IpPair> ipPairs = this.findPossibleIpPairs(localDeviceInfo, remoteDeviceInfo, sourceIp);
            for (IpPair pair : ipPairs) {
                ConnectionResult result = this.tryConnect(pair.localIp, pair.remoteIp, remoteDeviceInfo.getTcpServicePort());
                if (!result.isSuccess()) continue;
                return result;
            }
            return new ConnectionResult(false, null, null, remoteDeviceInfo.getTcpServicePort(), 0L, null);
        }

        private List<IpPair> findPossibleIpPairs(DiscoveredDevice localDevice, DiscoveredDevice remoteDevice, String sourceIp) {
            ArrayList<IpPair> result = new ArrayList<IpPair>();
            if (sourceIp != null) {
                for (DiscoveredDevice.NetworkInterface localIface : localDevice.getNetworkInterfaces()) {
                    if (!this.isSameSubnet(localIface.getIpAddress(), sourceIp, localIface.getSubnetMask())) continue;
                    result.add(new IpPair(localIface.getIpAddress(), sourceIp, 10));
                    break;
                }
            }
            for (DiscoveredDevice.NetworkInterface localIface : localDevice.getNetworkInterfaces()) {
                for (DiscoveredDevice.NetworkInterface remoteIface : remoteDevice.getNetworkInterfaces()) {
                    if (this.isSameSubnet(localIface.getIpAddress(), remoteIface.getIpAddress(), "255.255.255.0")) {
                        result.add(new IpPair(localIface.getIpAddress(), remoteIface.getIpAddress(), 20));
                        continue;
                    }
                    if (!this.isSameSubnet(localIface.getIpAddress(), remoteIface.getIpAddress(), "255.255.0.0")) continue;
                    result.add(new IpPair(localIface.getIpAddress(), remoteIface.getIpAddress(), 30));
                }
            }
            for (DiscoveredDevice.NetworkInterface localIface : localDevice.getNetworkInterfaces()) {
                for (DiscoveredDevice.NetworkInterface remoteIface : remoteDevice.getNetworkInterfaces()) {
                    if (result.stream().anyMatch(p -> p.localIp.equals(localIface.getIpAddress()) && p.remoteIp.equals(remoteIface.getIpAddress()))) continue;
                    result.add(new IpPair(localIface.getIpAddress(), remoteIface.getIpAddress(), 40));
                }
            }
            result.sort(Comparator.comparingInt(p -> p.priority));
            return result;
        }

        private ConnectionResult tryConnect(String localIp, String remoteIp, int remotePort) {
            System.out.println("\u5c1d\u8bd5\u8fde\u63a5: " + localIp + " -> " + remoteIp + ":" + remotePort);
            try {
                InetAddress localAddr = InetAddress.getByName(localIp);
                InetAddress remoteAddr = InetAddress.getByName(remoteIp);
                long startTime = System.currentTimeMillis();
                Socket socket = new Socket();
                socket.bind(new InetSocketAddress(localAddr, 0));
                socket.connect(new InetSocketAddress(remoteAddr, remotePort), this.connectionTimeout);
                long connectTime = System.currentTimeMillis() - startTime;
                System.out.println("\u8fde\u63a5\u6210\u529f: " + localIp + " -> " + remoteIp + ":" + remotePort + " (" + connectTime + "ms)");
                return new ConnectionResult(true, localIp, remoteIp, remotePort, connectTime, socket);
            }
            catch (Exception e) {
                System.out.println("\u8fde\u63a5\u5931\u8d25: " + localIp + " -> " + remoteIp + ":" + remotePort + " (" + e.getMessage() + ")");
                return new ConnectionResult(false, localIp, remoteIp, remotePort, 0L, null);
            }
        }

        private boolean isSameSubnet(String ip1, String ip2, String subnetMask) {
            try {
                byte[] addr1 = InetAddress.getByName(ip1).getAddress();
                byte[] addr2 = InetAddress.getByName(ip2).getAddress();
                byte[] mask = InetAddress.getByName(subnetMask).getAddress();
                if (addr1.length != addr2.length || addr1.length != mask.length) {
                    return false;
                }
                for (int i = 0; i < addr1.length; ++i) {
                    if ((addr1[i] & mask[i]) == (addr2[i] & mask[i])) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private static class IpPair {
            final String localIp;
            final String remoteIp;
            final int priority;

            IpPair(String localIp, String remoteIp, int priority) {
                this.localIp = localIp;
                this.remoteIp = remoteIp;
                this.priority = priority;
            }
        }

        public static class ConnectionResult {
            private final boolean success;
            private final String localIp;
            private final String remoteIp;
            private final int remotePort;
            private final long connectTimeMs;
            private final Socket socket;

            public ConnectionResult(boolean success, String localIp, String remoteIp, int remotePort, long connectTimeMs, Socket socket) {
                this.success = success;
                this.localIp = localIp;
                this.remoteIp = remoteIp;
                this.remotePort = remotePort;
                this.connectTimeMs = connectTimeMs;
                this.socket = socket;
            }

            public boolean isSuccess() {
                return this.success;
            }

            public String getLocalIp() {
                return this.localIp;
            }

            public String getRemoteIp() {
                return this.remoteIp;
            }

            public int getRemotePort() {
                return this.remotePort;
            }

            public long getConnectTimeMs() {
                return this.connectTimeMs;
            }

            public Socket getSocket() {
                return this.socket;
            }

            public String toString() {
                return "ConnectionResult{success=" + this.success + ", localIp='" + this.localIp + '\'' + ", remoteIp='" + this.remoteIp + '\'' + ", remotePort=" + this.remotePort + ", connectTime=" + this.connectTimeMs + "ms" + '}';
            }
        }
    }
}

