/*
 * Decompiled with CFR 0.152.
 */
package com.test.pake;

import com.test.pake.SimplePAKE;
import java.math.BigInteger;
import java.util.Arrays;

public class SimplePAKETest {
    private static final String CORRECT_PASSWORD = "test_password_123";
    private static final String WRONG_PASSWORD = "wrong_password_456";

    public static void test_successful_key_exchange() {
        System.out.println("\n=== \u6d4b\u8bd5\u6210\u529f\u7684\u5bc6\u94a5\u4ea4\u6362 ===");
        SimplePAKE.PAKEParty alice = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        SimplePAKE.PAKEParty bob = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        System.out.println("\u521b\u5efa Alice \u548c Bob\uff0c\u4f7f\u7528\u76f8\u540c\u5bc6\u7801: test_password_123");
        System.out.println("1. \u751f\u6210\u516c\u5f00\u503c");
        BigInteger alice_public = alice.generate_public_value();
        BigInteger bob_public = bob.generate_public_value();
        if (alice_public == null || bob_public == null) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u516c\u5f00\u503c\u4e3a\u7a7a");
            return;
        }
        if (alice_public.compareTo(BigInteger.ZERO) <= 0 || bob_public.compareTo(BigInteger.ZERO) <= 0) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u516c\u5f00\u503c\u5fc5\u987b\u4e3a\u6b63\u6570");
            return;
        }
        System.out.println("   Alice \u516c\u5f00\u503c: " + alice_public.toString(16).substring(0, Math.min(32, alice_public.toString(16).length())) + "...");
        System.out.println("   Bob \u516c\u5f00\u503c: " + bob_public.toString(16).substring(0, Math.min(32, bob_public.toString(16).length())) + "...");
        System.out.println("2. \u8ba1\u7b97\u5171\u4eab\u5bc6\u94a5");
        alice.compute_shared_key(bob_public);
        bob.compute_shared_key(alice_public);
        BigInteger alice_key = alice.get_shared_key();
        BigInteger bob_key = bob.get_shared_key();
        if (alice_key == null || bob_key == null) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u5171\u4eab\u5bc6\u94a5\u4e3a\u7a7a");
            return;
        }
        if (!alice_key.equals(bob_key)) {
            System.out.println("   \u2717 \u9519\u8bef\uff1aAlice \u548c Bob \u7684\u5171\u4eab\u5bc6\u94a5\u4e0d\u5339\u914d");
            return;
        }
        System.out.println("   \u5171\u4eab\u5bc6\u94a5\u5339\u914d: \u2713");
        System.out.println("   \u5bc6\u94a5\u957f\u5ea6: " + alice_key.bitLength() + " bits");
        System.out.println("3. \u9a8c\u8bc1\u76f8\u4e92\u8ba4\u8bc1");
        byte[] alice_auth = alice.generate_auth_code("Alice");
        byte[] bob_auth = bob.generate_auth_code("Bob");
        if (alice_auth.length == 0 || bob_auth.length == 0) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u8ba4\u8bc1\u7801\u957f\u5ea6\u4e3a0");
            return;
        }
        boolean alice_verified = bob.verify_auth_code(alice_auth, "Alice");
        boolean bob_verified = alice.verify_auth_code(bob_auth, "Bob");
        if (!alice_verified || !bob_verified) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u76f8\u4e92\u8ba4\u8bc1\u5931\u8d25");
            return;
        }
        System.out.println("   \u76f8\u4e92\u8ba4\u8bc1\u6210\u529f: \u2713");
        System.out.println("\u2713 \u6210\u529f\u5bc6\u94a5\u4ea4\u6362\u6d4b\u8bd5\u901a\u8fc7");
    }

    public static void test_different_passwords() {
        System.out.println("\n=== \u6d4b\u8bd5\u4e0d\u540c\u5bc6\u7801\u573a\u666f ===");
        SimplePAKE.PAKEParty alice_wrong = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        SimplePAKE.PAKEParty bob_wrong = new SimplePAKE.PAKEParty(WRONG_PASSWORD);
        System.out.println("1. Alice \u5bc6\u7801: test_password_123");
        System.out.println("   Bob \u5bc6\u7801: wrong_password_456");
        BigInteger alice_public = alice_wrong.generate_public_value();
        BigInteger bob_public = bob_wrong.generate_public_value();
        alice_wrong.compute_shared_key(bob_public);
        bob_wrong.compute_shared_key(alice_public);
        BigInteger alice_key = alice_wrong.get_shared_key();
        BigInteger bob_key = bob_wrong.get_shared_key();
        if (alice_key.equals(bob_key)) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u4e0d\u540c\u5bc6\u7801\u7adf\u7136\u4ea7\u751f\u4e86\u76f8\u540c\u7684\u5171\u4eab\u5bc6\u94a5");
            return;
        }
        System.out.println("2. \u4e0d\u540c\u5bc6\u7801\u4ea7\u751f\u4e0d\u540c\u5bc6\u94a5: \u2713");
        byte[] alice_auth = alice_wrong.generate_auth_code("Alice");
        boolean alice_verified = bob_wrong.verify_auth_code(alice_auth, "Alice");
        if (alice_verified) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u4e0d\u540c\u5bc6\u7801\u7684\u8ba4\u8bc1\u7adf\u7136\u6210\u529f\u4e86");
            return;
        }
        System.out.println("3. \u8ba4\u8bc1\u6b63\u786e\u5931\u8d25: \u2713");
        System.out.println("\u2713 \u4e0d\u540c\u5bc6\u7801\u6d4b\u8bd5\u901a\u8fc7");
    }

    public static void test_public_values_different() {
        System.out.println("\n=== \u6d4b\u8bd5\u516c\u5f00\u503c\u552f\u4e00\u6027 ===");
        SimplePAKE.PAKEParty alice1 = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        SimplePAKE.PAKEParty alice2 = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        BigInteger public1 = alice1.generate_public_value();
        BigInteger public2 = alice2.generate_public_value();
        if (public1.equals(public2)) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u76f8\u540c\u5bc6\u7801\u7684\u4e0d\u540c\u4f1a\u8bdd\u4ea7\u751f\u4e86\u76f8\u540c\u516c\u5f00\u503c");
            return;
        }
        System.out.println("1. \u516c\u5f00\u503c\u552f\u4e00\u6027\u9a8c\u8bc1: \u2713");
        System.out.println("   \u7b2c\u4e00\u6b21\u516c\u5f00\u503c: " + public1.toString(16).substring(0, Math.min(32, public1.toString(16).length())) + "...");
        System.out.println("   \u7b2c\u4e8c\u6b21\u516c\u5f00\u503c: " + public2.toString(16).substring(0, Math.min(32, public2.toString(16).length())) + "...");
        System.out.println("\u2713 \u516c\u5f00\u503c\u552f\u4e00\u6027\u6d4b\u8bd5\u901a\u8fc7");
    }

    public static void test_auth_code_consistency() {
        System.out.println("\n=== \u6d4b\u8bd5\u8ba4\u8bc1\u7801\u4e00\u81f4\u6027 ===");
        SimplePAKE.PAKEParty alice = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        SimplePAKE.PAKEParty bob = new SimplePAKE.PAKEParty(CORRECT_PASSWORD);
        BigInteger alice_public = alice.generate_public_value();
        BigInteger bob_public = bob.generate_public_value();
        alice.compute_shared_key(bob_public);
        bob.compute_shared_key(alice_public);
        byte[] auth1 = alice.generate_auth_code("TestIdentifier");
        byte[] auth2 = alice.generate_auth_code("TestIdentifier");
        if (!Arrays.equals(auth1, auth2)) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u76f8\u540c\u6807\u8bc6\u7b26\u4ea7\u751f\u4e86\u4e0d\u540c\u8ba4\u8bc1\u7801");
            return;
        }
        System.out.println("1. \u8ba4\u8bc1\u7801\u4e00\u81f4\u6027\u9a8c\u8bc1: \u2713");
        byte[] auth_diff = alice.generate_auth_code("DifferentIdentifier");
        if (Arrays.equals(auth1, auth_diff)) {
            System.out.println("   \u2717 \u9519\u8bef\uff1a\u4e0d\u540c\u6807\u8bc6\u7b26\u4ea7\u751f\u4e86\u76f8\u540c\u8ba4\u8bc1\u7801");
            return;
        }
        System.out.println("2. \u4e0d\u540c\u6807\u8bc6\u7b26\u4ea7\u751f\u4e0d\u540c\u8ba4\u8bc1\u7801: \u2713");
        System.out.println("\u2713 \u8ba4\u8bc1\u7801\u4e00\u81f4\u6027\u6d4b\u8bd5\u901a\u8fc7");
    }

    public static void main(String[] args) {
        System.out.println("=== PAKE \u534f\u8bae\u9a8c\u8bc1\u5f00\u59cb ===");
        SimplePAKETest.test_successful_key_exchange();
        SimplePAKETest.test_different_passwords();
        SimplePAKETest.test_public_values_different();
        SimplePAKETest.test_auth_code_consistency();
        System.out.println("\n=== \u6240\u6709\u9a8c\u8bc1\u6d4b\u8bd5\u5b8c\u6210 ===");
    }
}

