/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import java.lang.reflect.Type;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.eject.Ejecting;
import org.nutz.lang.inject.Injecting;

public abstract class AbstractEntityField
implements EntityField {
    protected Entity<?> entity;
    protected String name;
    protected Type type;
    protected Class<?> typeClass;
    protected Mirror<?> mirror;
    protected Injecting injecting;
    protected Ejecting ejecting;

    public AbstractEntityField(Entity<?> entity) {
        this.entity = entity;
    }

    @Override
    public Entity<?> getEntity() {
        return this.entity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public Mirror<?> getMirror() {
        return this.mirror;
    }

    @Override
    public void setValue(Object obj, Object value) {
        this.injecting.inject(obj, value);
    }

    @Override
    public Object getValue(Object obj) {
        return this.ejecting.eject(obj);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInjecting(Injecting injecting) {
        this.injecting = injecting;
    }

    public void setEjecting(Ejecting ejecting) {
        this.ejecting = ejecting;
    }

    public void setType(Type type) {
        this.type = type;
        this.typeClass = Lang.getTypeClass(type);
        this.mirror = Mirror.me(this.typeClass);
    }

    public void setEntity(Entity<?> entity) {
        this.entity = entity;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public void setMirror(Mirror<?> mirror) {
        this.mirror = mirror;
    }

    public String toString() {
        return String.format("'%s'(%s)", this.name, this.entity.getType().getName());
    }
}

