/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkType;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.field.AbstractLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class OneLinkField
extends AbstractLinkField {
    public OneLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info, Class<?> target, MappingField field, MappingField key) {
        super(entity, holder, info);
        this.targetType = target;
        this.hostField = field;
        this.linkedField = key;
    }

    public OneLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info) {
        super(entity, holder, info);
        this.targetType = this.guessTargetClass(info, info.one.target());
        if (Strings.isBlank(info.one.field())) {
            throw new DaoException("Invalid @One(field=\"\") at class=" + this.getEntity().getType().getName());
        }
        String hostFieldName = "_".equals(info.one.field()) ? info.name + "Id" : info.one.field();
        this.hostField = entity.getField(hostFieldName);
        if (null == this.hostField) {
            throw new DaoException(String.format("Invalid @One(field=%s) '%s' : %s<=>%s", hostFieldName, this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType()));
        }
        if (!Strings.isBlank(info.one.key())) {
            this.linkedField = this.getLinkedEntity().getField(info.one.key());
            if (this.linkedField == null) {
                throw new DaoException(String.format("Fail to find linkedField for @One(field=%s) '%s' : %s<=>%s By key=%s", hostFieldName, this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType(), info.one.key()));
            }
            return;
        }
        MappingField mappingField = this.linkedField = this.hostField.getMirror().isIntLike() ? this.getLinkedEntity().getIdField() : this.getLinkedEntity().getNameField();
        if (null == this.linkedField) {
            throw Lang.makeThrow("Fail to find linkedField for @One(field=%s) '%s' : %s<=>%s By %s", hostFieldName, this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType(), this.hostField.getMirror().isIntLike() ? "@Id" : "@Name");
        }
    }

    @Override
    public Condition createCondition(Object host) {
        return Cnd.where(this.linkedField.getColumnName(), "=", this.hostField.getValue(host));
    }

    @Override
    public void updateLinkedField(Object obj, Object linked) {
        Object val;
        if (this.hostField.isId() && (val = this.linkedField.getValue(linked)) != null && val instanceof Number && ((Number)val).doubleValue() == 0.0) {
            this.linkedField.setValue(linked, this.hostField.getValue(obj));
        }
    }

    @Override
    public void saveLinkedField(Object obj, Object linked) {
        Object v = this.linkedField.getValue(linked);
        this.hostField.setValue(obj, v);
    }

    @Override
    public LinkType getLinkType() {
        return LinkType.ONE;
    }
}

