/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.dm;

import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DmMysqlJdbcExpert
extends AbstractJdbcExpert {
    private static final Log log = Logs.get();

    public DmMysqlJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.DM_MYSQL.name();
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        if (mf.getColumnType() == ColType.INT) {
            int width = mf.getWidth();
            if (width <= 0) {
                return "INT";
            }
            if (width <= 4) {
                return "TINYINT";
            }
            if (width <= 6) {
                return "SMALLINT";
            }
            if (width <= 10) {
                return "INT";
            }
            return "BIGINT";
        }
        if (mf.getColumnType() == ColType.BOOLEAN) {
            return "TINYINT";
        }
        return super.evalFieldType(mf);
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnNameInSql());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                } else if (mf.getColumnType() == ColType.TIMESTAMP) {
                    sb.append(" NULL");
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" IDENTITY(1,1)");
                }
                if (mf.getColumnType() == ColType.TIMESTAMP) {
                    if (mf.hasDefaultValue()) {
                        sb.append(" ").append(this.getDefaultValue(mf));
                    } else if (mf.isNotNull()) {
                        sb.append(" DEFAULT 0");
                    } else {
                        sb.append(" DEFAULT NULL");
                    }
                } else if (mf.hasDefaultValue()) {
                    this.addDefaultValue(sb, mf);
                }
            }
            if (mf.hasColumnComment()) {
                sb.append(" COMMENT '").append(mf.getColumnComment()).append("'");
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnNameInSql()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        return true;
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " LIMIT 1";
    }

    @Override
    public boolean canCommentWhenAddIndex() {
        return true;
    }

    @Override
    protected Sql createRelation(Dao dao, LinkField lf) {
        Sql sql = super.createRelation(dao, lf);
        if (sql == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(sql.getSourceSql());
        return Sqls.create(sb.toString());
    }
}

