/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.tdengine;

import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class TDengineJdbcExpert
extends AbstractJdbcExpert {
    private static final Log log = Logs.get();

    public TDengineJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.TDENGINE.name();
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        return super.getAdaptor(ef);
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        int intLen = 4;
        int width = mf.getWidth();
        switch (mf.getColumnType()) {
            case INT: {
                if (width <= 0) {
                    return "INT(32)";
                }
                if (width <= 2) {
                    return "TINYINT(" + width * intLen + ")";
                }
                if (width <= 4) {
                    return "SMALLINT(" + width * intLen + ")";
                }
                if (width <= 8) {
                    return "INT(" + width * intLen + ")";
                }
                return "BIGINT(" + width * intLen + ")";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "BOOL";
            }
            case BINARY: {
                return "BINARY(" + width + ")";
            }
            case CHAR: 
            case VARCHAR: {
                return "NCHAR(" + width + ")";
            }
        }
        return super.evalFieldType(mf);
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnNameInSql());
            sb.append(' ').append(this.evalFieldType(mf));
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        return true;
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }
}

