/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import org.nutz.dao.Nesting;
import org.nutz.dao.util.cri.NestingExpression;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.lambda.LambdaQuery;
import org.nutz.dao.util.lambda.PFun;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class NestExps {
    public static NestingExpression eq(String name, Nesting val) {
        return new NestingExpression(name, "=", val);
    }

    public static <T> NestingExpression eq(PFun<T, ?> name, Nesting val) {
        return new NestingExpression(name, "=", val);
    }

    public static NestingExpression notEq(String name, Nesting val) {
        return new NestingExpression(name, "<>", val);
    }

    public static <T> NestingExpression notEq(PFun<T, ?> name, Nesting val) {
        return new NestingExpression(name, "<>", val);
    }

    public static NestingExpression like(String name, Nesting value) {
        return new NestingExpression(name, "LIKE", value);
    }

    public static <T> NestingExpression like(PFun<T, ?> name, Nesting value) {
        return new NestingExpression(name, "LIKE", value);
    }

    public static NestingExpression inSql(String name, Nesting value) {
        return new NestingExpression(name, "IN", value);
    }

    public static <T> NestingExpression inSql(PFun<T, ?> name, Nesting value) {
        return new NestingExpression(name, "IN", value);
    }

    public static NestingExpression exists(Nesting value) {
        return new NestingExpression("EXISTS", value);
    }

    public static NestingExpression otherSymbol(String name, String op, Nesting value) {
        return new NestingExpression(name, op, value);
    }

    public static <T> NestingExpression otherSymbol(PFun<T, ?> name, String op, Nesting value) {
        return new NestingExpression(name, op, value);
    }

    public static <T> SqlExpression create(PFun<T, ?> name, String op, Nesting value) {
        return NestExps.create(LambdaQuery.resolve(name), op, value);
    }

    public static SqlExpression create(String name, String op, Nesting value) {
        op = Strings.trim(op.toUpperCase());
        if (value == null) {
            throw Lang.makeThrow("nesting sql can not be null'", new Object[0]);
        }
        if ("LIKE".equals(op) || "NOT LIKE".equals(op)) {
            return NestExps.like(name, value).setNot(op.startsWith("NOT"));
        }
        if ("=".equals(op)) {
            return NestExps.eq(name, value);
        }
        if ("!=".equals(op) || "<>".equals(op)) {
            return NestExps.notEq(name, value);
        }
        if ("IN".equals(op) || "NOT IN".equals(op)) {
            return NestExps.inSql(name, value).setNot(op.startsWith("NOT"));
        }
        if ("EXISTS".equals(op) || "NOT EXISTS".equals(op)) {
            return NestExps.exists(value).setNot(op.startsWith("NOT"));
        }
        return NestExps.otherSymbol(name, op, value);
    }
}

