/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.lambda;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nutz.dao.util.lambda.PFun;

public class LambdaQuery {
    private static final Map<String, String> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, String>();

    public static <T> String resolve(PFun<T, ?> lambda) {
        Class<?> clazz = lambda.getClass();
        String className = clazz.getName();
        return Optional.ofNullable(COLUMN_CACHE_MAP.get(className)).orElseGet(() -> LambdaQuery.getPropertyName(className, lambda));
    }

    public static <T> String[] resolves(PFun<T, ?> ... lambda) {
        return Arrays.stream(lambda).map(LambdaQuery::resolve).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static <T> String getPropertyName(String className, PFun<T, ?> lambda) {
        if (!lambda.getClass().isSynthetic()) {
            throw new RuntimeException("\u8be5\u65b9\u6cd5\u4ec5\u80fd\u4f20\u5165 lambda \u8868\u8fbe\u5f0f\u4ea7\u751f\u7684\u5408\u6210\u7c7b");
        }
        try {
            Method writeReplace = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(lambda, new Object[0]);
            return COLUMN_CACHE_MAP.computeIfAbsent(className, s -> LambdaQuery.methodNameToPropertyName(serializedLambda.getImplMethodName()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f\u7684\u5f02\u5e38\uff01\uff01\uff01");
        }
    }

    public static String methodNameToPropertyName(String methodName) {
        if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        } else if (methodName.startsWith("get") || methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        } else {
            throw new RuntimeException("\u65b9\u6cd5\u540d'" + methodName + "'\u4e0d\u662f\u4ee5 'is','get','set' \u5f00\u59cb\u7684\uff01");
        }
        if (methodName.length() == 1 || methodName.length() > 1 && !Character.isUpperCase(methodName.charAt(1))) {
            methodName = methodName.substring(0, 1).toLowerCase(Locale.ENGLISH) + methodName.substring(1);
        }
        return methodName;
    }
}

