/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;

public class Response {
    private static final String DEF_PROTOCAL_VERSION = "HTTP/1.1";
    private Header header;
    private InputStream stream;
    private Cookie cookie;
    private String protocol = "HTTP/1.1";
    private int status;
    private String detail;
    private String content;
    private String encode;

    public Response() {
    }

    public Response(HttpURLConnection conn, Map<String, String> reHeader) throws IOException {
        this.status = conn.getResponseCode();
        this.detail = conn.getResponseMessage();
        this.header = Header.create(reHeader);
        for (String name : this.header.keys()) {
            if (!"Set-Cookie".equalsIgnoreCase(name)) continue;
            this.cookie = new Cookie();
            this.cookie.afterResponse(null, conn, null);
            break;
        }
        this.encode = this.getEncodeType();
    }

    public Response(HttpURLConnection conn, NutMap reHeader) throws IOException {
        this.status = conn.getResponseCode();
        this.detail = conn.getResponseMessage();
        this.header = Header.create(reHeader);
        for (String name : this.header.keys()) {
            if (!"Set-Cookie".equalsIgnoreCase(name)) continue;
            this.cookie = new Cookie();
            this.cookie.afterResponse(null, conn, null);
            break;
        }
        this.encode = this.getEncodeType();
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public String getProtocal() {
        return this.protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public boolean isOK() {
        return this.status == 200;
    }

    public boolean isServerError() {
        return this.status >= 500 && this.status < 600;
    }

    public boolean isClientError() {
        return this.status >= 400 && this.status < 500;
    }

    void setStream(InputStream stream) {
        this.stream = stream;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getEncodeType() {
        String contentType = this.header.get("Content-Type");
        if (null != contentType) {
            for (String tmp : contentType.split(";")) {
                if (tmp == null || !(tmp = tmp.trim()).startsWith("charset=")) continue;
                if ((tmp = Strings.trim(tmp.substring(8)).trim()).contains(",")) {
                    tmp = tmp.substring(0, tmp.indexOf(44)).trim();
                }
                return tmp;
            }
        }
        return "UTF-8";
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public String getEncode() {
        return this.encode;
    }

    public InputStream getStream() {
        return new BufferedInputStream(this.stream);
    }

    public Reader getReader() {
        String encoding = this.getEncodeType();
        if (null == encoding) {
            return this.getReader(Encoding.defaultEncoding());
        }
        return this.getReader(encoding);
    }

    public Reader getReader(String charsetName) {
        if (this.content != null) {
            return new StringReader(charsetName);
        }
        return new InputStreamReader(this.getStream(), Charset.forName(charsetName));
    }

    public Reader getReader(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset can not be null");
        }
        return this.getReader(charset.name());
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public void printHeader(Writer writer) {
        try {
            writer.write(this.header.toString());
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public void print(Writer writer) {
        this.print(writer, null);
    }

    public void print(Writer writer, String charsetName) {
        Reader reader = null;
        try {
            int c;
            reader = null == charsetName ? this.getReader() : this.getReader(charsetName);
            char[] buf = new char[8192];
            while (-1 != (c = reader.read(buf))) {
                writer.write(buf, 0, c);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public String getContent() {
        return this.getContent(this.encode);
    }

    public String getContent(String charsetName) {
        if (this.content == null) {
            this.content = charsetName == null ? Streams.readAndClose(this.getReader(this.encode)) : Streams.readAndClose(this.getReader(charsetName));
        }
        return this.content;
    }
}

