/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.lang.Lang;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.lang.reflect.ReflectTool;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.repo.org.objectweb.asm.ClassWriter;
import org.nutz.repo.org.objectweb.asm.Label;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;
import org.nutz.repo.org.objectweb.asm.commons.GeneratorAdapter;
import org.nutz.repo.org.objectweb.asm.commons.Method;

public class FastMethodFactory
implements Opcodes {
    protected static ConcurrentHashMap<String, FastMethod> cache = new ConcurrentHashMap();
    protected static final Log log = Logs.get();
    protected static Method _M = FastMethodFactory._Method("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
    protected static Type Exception_TYPE = Type.getType(Throwable.class);

    protected static FastMethod make(java.lang.reflect.Method method) {
        Class<?> klass = method.getDeclaringClass();
        String descriptor = Type.getMethodDescriptor(method) + method.getDeclaringClass().getClassLoader();
        String key = "$FM$" + method.getName() + "$" + Lang.md5(descriptor);
        String className = ReflectTool.class.getPackage().getName() + "." + Lang.md5(klass.getName()) + key;
        FastMethod fm = cache.get(className);
        if (fm != null) {
            return fm;
        }
        if (!Modifier.isPublic(klass.getModifiers())) {
            fm = new FallbackFastMethod(method);
            cache.put(className, fm);
            return fm;
        }
        try {
            fm = (FastMethod)klass.getClassLoader().loadClass(className).newInstance();
            cache.put(className, fm);
            return fm;
        }
        catch (Throwable throwable) {
            try {
                byte[] buf = FastMethodFactory._make(klass, method.getModifiers(), method.getParameterTypes(), FastMethodFactory._Method(method), method.getReturnType(), className, descriptor);
                Class<?> t = DefaultClassDefiner.defaultOne().define(className, buf, klass.getClassLoader());
                fm = (FastMethod)t.newInstance();
            }
            catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    log.trace("Fail to create FastMethod for " + method, e);
                }
                fm = new FallbackFastMethod(method);
            }
            cache.put(className, fm);
            return fm;
        }
    }

    protected static FastMethod make(Constructor<?> constructor) {
        Class<?> klass = constructor.getDeclaringClass();
        String descriptor = Type.getConstructorDescriptor(constructor) + constructor.getDeclaringClass().getClassLoader();
        String key = Lang.md5(descriptor);
        String className = ReflectTool.class.getPackage().getName() + "." + Lang.md5(klass.getName()) + "$FC$" + key;
        FastMethod fm = cache.get(className);
        if (fm != null) {
            return fm;
        }
        try {
            fm = (FastMethod)klass.getClassLoader().loadClass(className).newInstance();
            cache.put(key, fm);
            return fm;
        }
        catch (Throwable throwable) {
            try {
                byte[] buf = FastMethodFactory._make(klass, constructor.getModifiers(), constructor.getParameterTypes(), FastMethodFactory._Method(constructor), null, className, descriptor);
                Class<?> t = DefaultClassDefiner.defaultOne().define(className, buf, klass.getClassLoader());
                fm = (FastMethod)t.newInstance();
            }
            catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    log.trace("Fail to create FastMethod for " + constructor, e);
                }
                fm = new FallbackFastMethod(constructor);
            }
            cache.put(className, fm);
            return fm;
        }
    }

    public static byte[] _make(Class<?> klass, int mod, Class<?>[] params, Method method, Class<?> returnType, String className, String descriptor) {
        ClassWriter cw = new ClassWriter(2);
        cw.visit(49, 1, className.replace('.', '/'), null, "java/lang/Object", new String[]{FastMethod.class.getName().replace('.', '/')});
        Type klassType = Type.getType(klass);
        FastMethodFactory.addConstructor(cw, Type.getType(Object.class), Method.getMethod("void <init> ()"));
        GeneratorAdapter mg = new GeneratorAdapter(1, _M, null, new Type[]{Exception_TYPE}, cw);
        if (returnType == null) {
            mg.newInstance(klassType);
            mg.dup();
        } else if (!Modifier.isStatic(mod)) {
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(klassType);
        }
        if (params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                mg.loadArg(1);
                mg.push(i);
                mg.arrayLoad(Type.getType(Object.class));
                Type paramType = Type.getType(params[i]);
                if (params[i].isPrimitive()) {
                    mg.unbox(paramType);
                    continue;
                }
                mg.checkCast(paramType);
            }
        }
        if (returnType == null) {
            mg.invokeConstructor(klassType, method);
        } else {
            if (Modifier.isStatic(mod)) {
                mg.invokeStatic(klassType, method);
            } else if (Modifier.isInterface(klass.getModifiers())) {
                mg.invokeInterface(klassType, method);
            } else {
                mg.invokeVirtual(klassType, method);
            }
            if (Void.class.equals(returnType)) {
                mg.visitInsn(1);
            } else if (returnType.isPrimitive()) {
                mg.box(Type.getType(returnType));
            }
        }
        Label tmp = new Label();
        mg.visitLabel(tmp);
        mg.visitLineNumber(1, tmp);
        mg.returnValue();
        mg.endMethod();
        cw.visitSource(klass.getSimpleName() + ".java", null);
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static Method _Method(String name, String desc) {
        return new Method(name, desc);
    }

    public static Method _Method(java.lang.reflect.Method method) {
        return Method.getMethod(method);
    }

    public static Method _Method(String method) {
        return Method.getMethod(method);
    }

    private static Method _Method(Constructor<?> constructor) {
        return Method.getMethod(constructor);
    }

    public static void addConstructor(ClassWriter cw, Type parent, Method m) {
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, null, cw);
        mg.loadThis();
        mg.loadArgs();
        mg.invokeConstructor(parent, m);
        mg.returnValue();
        mg.endMethod();
    }

    public static class FallbackFastMethod
    implements FastMethod {
        public java.lang.reflect.Method method;
        public Constructor<?> constructor;

        public FallbackFastMethod(java.lang.reflect.Method method) {
            this.method = method;
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
        }

        public FallbackFastMethod(Constructor<?> constructor) {
            this.constructor = constructor;
            if (!this.constructor.isAccessible()) {
                this.constructor.setAccessible(true);
            }
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws Exception {
            if (this.method == null) {
                return this.constructor.newInstance(args);
            }
            return this.method.invoke(obj, args);
        }
    }
}

