/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.util.MultiLineProperties;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.MessageLoader;
import org.nutz.mvc.impl.NutMessageMap;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class NutMessageLoader
implements MessageLoader {
    private static final Log log = Logs.get();

    @Override
    public Map<String, Map<String, Object>> load(String refer) {
        HashMap<String, Map<String, Object>> re = new HashMap<String, Map<String, Object>>();
        List<NutResource> allnrs = Scans.me().scan(refer, "^.+[.]properties$");
        if (log.isDebugEnabled()) {
            log.debugf("Load Messages in %s resource : [%s]", allnrs.size(), allnrs);
        }
        int max = 0;
        for (NutResource nutResource : allnrs) {
            String[] nms = nutResource.getName().split("[\\\\/]");
            max = Math.max(max, nms.length);
        }
        HashMap<String, ArrayList<NutResource>> map = new HashMap<String, ArrayList<NutResource>>();
        for (NutResource nr : allnrs) {
            String resName = nr.getName();
            String langType = resName.contains("/") ? resName.substring(0, resName.indexOf(47)) : (resName.contains("\\") ? resName.substring(0, resName.indexOf(92)) : "$default");
            ArrayList<NutResource> list = (ArrayList<NutResource>)map.get(langType);
            if (null == list) {
                list = new ArrayList<NutResource>(10);
                map.put(langType, list);
            }
            list.add(nr);
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                List nrs = (List)entry.getValue();
                String langType = (String)entry.getKey();
                for (NutResource nr : nrs) {
                    MultiLineProperties p = new MultiLineProperties();
                    Reader r = nr.getReader();
                    p.load(r);
                    r.close();
                    Map msgs = (Map)re.get(langType);
                    if (null == msgs) {
                        msgs = new NutMessageMap();
                        re.put(langType, msgs);
                    }
                    for (Map.Entry<String, String> en : p.entrySet()) {
                        msgs.put(en.getKey(), en.getValue());
                    }
                }
            }
        }
        catch (Exception exception) {
            throw Lang.wrapThrow(exception);
        }
        if (!re.containsKey("$default") && re.size() > 0) {
            String string = (String)re.keySet().iterator().next();
            re.put("$default", (Map)re.get(string));
        }
        if (log.isDebugEnabled()) {
            log.debugf("Message Loaded, size = %s", re.size());
        }
        return re;
    }
}

