/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.reqmatcher;

import java.util.HashMap;
import java.util.Map;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.RequestMatcher;
import org.nutz.mvc.annotation.ApiVersion;
import org.nutz.mvc.impl.reqmatcher.DefaultRequestMatcher;

public class ApiVersionRequestMatcher
implements RequestMatcher {
    protected int index = -1;
    protected Map<String, DefaultRequestMatcher> matchers;
    protected boolean keepPathArg;

    @Override
    public void add(String path, ActionInfo ai, ActionChain chain) {
        ApiVersion panno = ai.getModuleType().getAnnotation(ApiVersion.class);
        if (panno != null) {
            String[] namedPathArgs;
            ApiVersion anno = ai.getMethod().getAnnotation(ApiVersion.class);
            if (anno == null) {
                anno = panno;
            }
            if ((namedPathArgs = ai.getNamedPathArgs()) != null) {
                for (int i = 0; i < namedPathArgs.length; ++i) {
                    DefaultRequestMatcher matcher;
                    if (!"version".equals(namedPathArgs[i])) continue;
                    this.index = i;
                    if (this.matchers == null) {
                        this.matchers = new HashMap<String, DefaultRequestMatcher>();
                    }
                    if ((matcher = this.matchers.get(anno.value())) == null) {
                        matcher = new DefaultRequestMatcher();
                        this.matchers.put(anno.value(), matcher);
                    }
                    matcher.add(path, ai, chain);
                    if (anno.keepPathArg()) {
                        this.keepPathArg = true;
                    }
                    return;
                }
            }
        }
    }

    @Override
    public ActionChain match(ActionContext ctx) {
        ActionChain chain;
        if (this.matchers == null || ctx.getPathArgs().size() <= this.index) {
            return null;
        }
        String version = ctx.getPathArgs().get(this.index);
        if (version == null) {
            return null;
        }
        DefaultRequestMatcher matcher = this.matchers.get(version);
        if (matcher != null && (chain = matcher.match(ctx)) != null) {
            if (!this.keepPathArg) {
                ctx.getPathArgs().remove(this.index);
            }
            return chain;
        }
        return null;
    }
}

