/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.reqmatcher;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.RequestMatcher;

public class DefaultRequestMatcher
implements RequestMatcher {
    private static final Log log = Logs.get();
    protected Map<String, ActionChain> chainMap;
    protected ActionChain defaultChain;

    @Override
    public void add(String path, ActionInfo ai, ActionChain chain) {
        if (ai.isForSpecialHttpMethod()) {
            for (String httpMethod : ai.getHttpMethods()) {
                if (this.chainMap == null) {
                    this.chainMap = new HashMap<String, ActionChain>();
                }
                this.chainMap.put(httpMethod, chain);
            }
        } else {
            this.defaultChain = chain;
        }
    }

    @Override
    public ActionChain match(ActionContext ac) {
        HttpServletRequest req;
        ActionChain chain;
        String httpMethod = "";
        if (this.chainMap != null && !this.chainMap.isEmpty() && null != (chain = this.chainMap.get(httpMethod = Strings.sNull((req = ac.getRequest()).getMethod(), "GET").toUpperCase()))) {
            return chain;
        }
        if (null != this.defaultChain) {
            return this.defaultChain;
        }
        if (this.chainMap != null && this.chainMap.size() != 0 && log.isDebugEnabled()) {
            log.debugf("Path=[%s] available methods%s but request [%s], using the wrong http method?", ac.getPath(), this.chainMap.keySet(), httpMethod);
        }
        return null;
    }

    public void addChain(String httpMethod, ActionChain chain) {
        if (this.chainMap == null) {
            this.chainMap = new HashMap<String, ActionChain>();
        }
        this.chainMap.put(httpMethod, chain);
    }

    public void setDefaultChain(ActionChain defaultChain) {
        this.defaultChain = defaultChain;
    }
}

