/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.validate.impl;

import java.util.ArrayList;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.validate.NutValidateException;
import org.nutz.validate.NutValidator;

public class StrEnumValidator
implements NutValidator {
    private String[] strs;

    public StrEnumValidator(Object any) {
        if (any instanceof CharSequence) {
            this.strs = Strings.splitIgnoreBlank(any.toString());
        } else {
            final ArrayList list = new ArrayList();
            Lang.each(any, new Each<Object>(){

                @Override
                public void invoke(int index, Object ele, int length) {
                    list.add(ele.toString());
                }
            });
            this.strs = list.toArray(new String[list.size()]);
        }
    }

    @Override
    public Object check(Object val) throws NutValidateException {
        if (null == val) {
            return val;
        }
        String s = val.toString();
        for (String str : this.strs) {
            if (!str.equals(s)) continue;
            return s;
        }
        throw new NutValidateException("StrOutOfEnum", this.strs.toString(), val);
    }

    @Override
    public int order() {
        return 1000;
    }
}

